#pragma once

#include "gmplugin.h"

class DB
{
	static sqlite3 *Database;
	static int Callback(void *Data, int argc, char **ColumnData, char **Columns);
public:

	struct Column
	{
		StringClass Name;
		StringClass Data;
	};

	struct Row
	{
		DynamicVectorClass<Column *> *Columns;
	};

	static bool Query(DynamicVectorClass<Row*>* VectorOut, const char *Format, ...);
	static bool Query(const char *Format, ...);
	static void Delete_Result(DynamicVectorClass<Row *>* List);
	static StringClass Get_Column_Data(const char *Name, DynamicVectorClass<Column *> *Row);
	static void Create_Tables();

	static void Load();
	static void Unload();
}; 